definition module LibraryInstance;

import StdEnv;
import StdMaybe;
//import State;
import NamesTable;

//1.3
from BitSet import BitSet;
from pdSymbolTable import LibraryList, EmptyLibraryList;
//3.1
/*2.0
from BitSet import ::BitSet;
from pdSymbolTable import ::LibraryList, EmptyLibraryList;
0.2*/

:: *LibraryInstance 
	= {
		li_library_name		:: !Maybe !String				// file name of library
	,	li_type_table_i		:: !Int							// index in cs_type_tables
	
	,	li_s_type_available	:: !Int							// size of array below
	,	li_type_available	:: !*{#Bool}					// index in type implementation table True = made available, False = not available valid for chosen types from current library instance

	,	li_names_table		:: !*NamesTable					// names table
	,	li_library_list		:: !LibraryList

	,	li_initial_types_equivalences_entered 	:: !Bool	// internal type equivalences i.e. within library instance and types which implement type-component of dynamic
	
	,	li_library_initialized	:: !Bool					// names table is non-empty, marked_bool_a, marked_offset_a, etc. are adapted which is reflected in app_linker_state (DLClientState)
	
	,	li_dynamic_index	:: !Maybe !Int					// index in cs_dynamic_info
	
/*
	,	li_code_begin		:: !Int
	,	li_code_end			:: !Int
	,	li_data_begin		:: !Int
	,	li_data_end			:: !Int	
*/
	
	,	li_memory_areas		:: [MemoryArea]
	};
	
:: MemoryArea
	= {
		ma_begin			:: !Int
	,	ma_end				:: !Int
	};
	
default_library_instance :: *LibraryInstance;
		
:: *LibraryInstances
	= { 
		lis_n_library_instances		:: !Int
	,	lis_library_instances		:: !*{#*LibraryInstance}
	};

default_library_instances :: *LibraryInstances;
	
class Library_Instances a
where {
	AddLibraryInstance :: (!Maybe !Int) !String !Int !*a -> (!Int,!*a)
};
	
instance Library_Instances LibraryInstances;